<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


class CNewsWidgetArticlesWCarousel extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "2",
		"name"	=> "Articles w/ Carousel",
		"module"	=> array(
			"name"	=> "",
			"id"	=> "",
			"type"	=> "",
		)
	);

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {
		global $_SESS;

		$cnt = max(1, $widget["settings"]["set_items"]);


		switch ($widget["settings"]["set_type"]) {
			//latest
			default:
				$order = "item_date DESC";
			break;

			//most viewed
			case "2":
				$order = "item_set_views DESC , item_date DESC";
			break;
		}

		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:news_items']} as t , 
				{$this->tables['plugin:news_items_lang']} as l 
			WHERE 
				t.module_id = {$widget[mod_id]} AND 
				l.lang_id={$widget[lang_id]} AND 
				t.item_id=l.item_id 
			ORDER BY 
				{$order}
			LIMIT 
				$cnt
			"
		);


		if (is_array($items)) {

			global $base;


			if ($widget["settings"]["set_carousel"]) {
				$options = array(
					"max"	=> "1",
					"path"	=> "upload/news",
					"tn"	=> $widget["settings"]["set_media_height"] ? "tn2" : "tn",

				);
			} else {
				$options = array(
					"path"	=> "upload/news",
					"tn"	=> $widget["settings"]["set_media_height"] ? "tn2" : "tn",
				);
			}

			if ($widget["settings"]["set_style"] == "blog-topics-clasic") {
				$widget["settings"]["set_size"] = 
				$widget["settings"]["set_size_lg"] = 
				$widget["settings"]["set_size_md"] = 
				$widget["settings"]["set_size_sm"] = 
				$widget["settings"]["set_size_xs"] = "12";
			}

			$elements = explode("," , $widget["settings"]["set_elements"]);


			foreach ($items as $key => $val) {
				//force to show only one image
				$val["item_image"] = "1";
				$val["link"] = $items[$key]["link"] = $widget["link"] .$val["item_url"] . "/" . $val["item_id"];
				$this->module->ProcessElements($items[$key], $elements , $this->tpl , "listing" , $widget["mod_settings"] , $widget["settings"]["set_carousel"]);
			}
			

			return $this->tpl->blockReplace(
				"Main" , 
				array(
					"items"			=> $base->html->table(
						$this->tpl, 
						"" , 
						$items
					),
					"class"	=> $this->tpl->blockreplace($widget["settings"]["set_carousel"] ? "Carousel" :"List"),

				),
				$widget,
				$widget["settings"],
				$widget["mod_settings"]
			);
		}

	}
	
}


?>